<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface BuybillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Buybill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param buybill primary key
 	 */
	public function delete($buybillid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Buybill buybill
 	 */
	public function insert($buybill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Buybill buybill
 	 */
	public function update($buybill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuybillSerial($value);

	public function queryByBuybilldate($value);

	public function queryByBuybillsupplierid($value);

	public function queryByBuybilltotaldeptbefor($value);

	public function queryByBuybilltotaldeptafter($value);

	public function queryByBuybilldiscount($value);

	public function queryByBuybilldiscountrype($value);

	public function queryByBuybilltotalbill($value);

	public function queryByBuybillaftertotalbill($value);

	public function queryByBuybilltotalpayed($value);

	public function queryByBuybillfinalbill($value);

	public function queryByBuybillstoreid($value);

	public function queryByBuybillsysdate($value);

	public function queryByUserid($value);

	public function queryByCondition($value);

	public function queryByBuybillclientname($value);

	public function queryByBuybillsaveid($value);

	public function queryByBuybilldirectpayment($value);

	public function queryByBillnameid($value);


	public function deleteByBuybillSerial($value);

	public function deleteByBuybilldate($value);

	public function deleteByBuybillsupplierid($value);

	public function deleteByBuybilltotaldeptbefor($value);

	public function deleteByBuybilltotaldeptafter($value);

	public function deleteByBuybilldiscount($value);

	public function deleteByBuybilldiscountrype($value);

	public function deleteByBuybilltotalbill($value);

	public function deleteByBuybillaftertotalbill($value);

	public function deleteByBuybilltotalpayed($value);

	public function deleteByBuybillfinalbill($value);

	public function deleteByBuybillstoreid($value);

	public function deleteByBuybillsysdate($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);

	public function deleteByBuybillclientname($value);

	public function deleteByBuybillsaveid($value);

	public function deleteByBuybilldirectpayment($value);

	public function deleteByBillnameid($value);


}
?>